/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessageListCopier;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailabilityZone
implements ToCopyableBuilder<Builder, AvailabilityZone> {
    private final String state;
    private final List<AvailabilityZoneMessage> messages;
    private final String regionName;
    private final String zoneName;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
    }

    public String state() {
        return this.state;
    }

    public List<AvailabilityZoneMessage> messages() {
        return this.messages;
    }

    public String regionName() {
        return this.regionName;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        hashCode = 31 * hashCode + (this.regionName() == null ? 0 : this.regionName().hashCode());
        hashCode = 31 * hashCode + (this.zoneName() == null ? 0 : this.zoneName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        if (other.zoneName() == null ^ this.zoneName() == null) {
            return false;
        }
        return other.zoneName() == null || other.zoneName().equals(this.zoneName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        if (this.regionName() != null) {
            sb.append("RegionName: ").append(this.regionName()).append(",");
        }
        if (this.zoneName() != null) {
            sb.append("ZoneName: ").append(this.zoneName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String state;
        private List<AvailabilityZoneMessage> messages;
        private String regionName;
        private String zoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.setState(model.state);
            this.setMessages(model.messages);
            this.setRegionName(model.regionName);
            this.setZoneName(model.zoneName);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<AvailabilityZoneMessage> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailabilityZone> {
        public Builder state(String var1);

        public Builder state(AvailabilityZoneState var1);

        public Builder messages(Collection<AvailabilityZoneMessage> var1);

        public Builder messages(AvailabilityZoneMessage ... var1);

        public Builder regionName(String var1);

        public Builder zoneName(String var1);
    }
}

