/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ExportEnvironment;
import software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstanceExportTaskRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
    private final String description;
    private final ExportToS3TaskSpecification exportToS3Task;
    private final String instanceId;
    private final String targetEnvironment;

    private CreateInstanceExportTaskRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    public String description() {
        return this.description;
    }

    public ExportToS3TaskSpecification exportToS3Task() {
        return this.exportToS3Task;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String targetEnvironment() {
        return this.targetEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.exportToS3Task() == null ? 0 : this.exportToS3Task().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.targetEnvironment() == null ? 0 : this.targetEnvironment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskRequest)) {
            return false;
        }
        CreateInstanceExportTaskRequest other = (CreateInstanceExportTaskRequest)((Object)obj);
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.exportToS3Task() == null ^ this.exportToS3Task() == null) {
            return false;
        }
        if (other.exportToS3Task() != null && !other.exportToS3Task().equals(this.exportToS3Task())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.targetEnvironment() == null ^ this.targetEnvironment() == null) {
            return false;
        }
        return other.targetEnvironment() == null || other.targetEnvironment().equals(this.targetEnvironment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.exportToS3Task() != null) {
            sb.append("ExportToS3Task: ").append(this.exportToS3Task()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.targetEnvironment() != null) {
            sb.append("TargetEnvironment: ").append(this.targetEnvironment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private ExportToS3TaskSpecification exportToS3Task;
        private String instanceId;
        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskRequest model) {
            this.setDescription(model.description);
            this.setExportToS3Task(model.exportToS3Task);
            this.setInstanceId(model.instanceId);
            this.setTargetEnvironment(model.targetEnvironment);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ExportToS3TaskSpecification getExportToS3Task() {
            return this.exportToS3Task;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return this.targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        public CreateInstanceExportTaskRequest build() {
            return new CreateInstanceExportTaskRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
        public Builder description(String var1);

        public Builder exportToS3Task(ExportToS3TaskSpecification var1);

        public Builder instanceId(String var1);

        public Builder targetEnvironment(String var1);

        public Builder targetEnvironment(ExportEnvironment var1);
    }
}

