/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationOfferingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
    private final List<Filter> filter;
    private final Integer maxDuration;
    private final Integer maxResults;
    private final Integer minDuration;
    private final String nextToken;
    private final String offeringId;

    private DescribeHostReservationOfferingsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.maxDuration = builder.maxDuration;
        this.maxResults = builder.maxResults;
        this.minDuration = builder.minDuration;
        this.nextToken = builder.nextToken;
        this.offeringId = builder.offeringId;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public Integer maxDuration() {
        return this.maxDuration;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer minDuration() {
        return this.minDuration;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.maxDuration() == null ? 0 : this.maxDuration().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.minDuration() == null ? 0 : this.minDuration().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsRequest)) {
            return false;
        }
        DescribeHostReservationOfferingsRequest other = (DescribeHostReservationOfferingsRequest)((Object)obj);
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.maxDuration() == null ^ this.maxDuration() == null) {
            return false;
        }
        if (other.maxDuration() != null && !other.maxDuration().equals(this.maxDuration())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.minDuration() == null ^ this.minDuration() == null) {
            return false;
        }
        if (other.minDuration() != null && !other.minDuration().equals(this.minDuration())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        return other.offeringId() == null || other.offeringId().equals(this.offeringId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.maxDuration() != null) {
            sb.append("MaxDuration: ").append(this.maxDuration()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.minDuration() != null) {
            sb.append("MinDuration: ").append(this.minDuration()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filter;
        private Integer maxDuration;
        private Integer maxResults;
        private Integer minDuration;
        private String nextToken;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsRequest model) {
            this.setFilter(model.filter);
            this.setMaxDuration(model.maxDuration);
            this.setMaxResults(model.maxResults);
            this.setMinDuration(model.minDuration);
            this.setNextToken(model.nextToken);
            this.setOfferingId(model.offeringId);
        }

        public final Collection<Filter> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        public final Integer getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMinDuration() {
            return this.minDuration;
        }

        @Override
        public final Builder minDuration(Integer minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public DescribeHostReservationOfferingsRequest build() {
            return new DescribeHostReservationOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder maxDuration(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder minDuration(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringId(String var1);
    }
}

