/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMovingAddressesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeMovingAddressesRequest> {
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> publicIps;

    private DescribeMovingAddressesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.publicIps = builder.publicIps;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> publicIps() {
        return this.publicIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.publicIps() == null ? 0 : this.publicIps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesRequest)) {
            return false;
        }
        DescribeMovingAddressesRequest other = (DescribeMovingAddressesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.publicIps() == null ^ this.publicIps() == null) {
            return false;
        }
        return other.publicIps() == null || other.publicIps().equals(this.publicIps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.publicIps() != null) {
            sb.append("PublicIps: ").append(this.publicIps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private Integer maxResults;
        private String nextToken;
        private List<String> publicIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesRequest model) {
            this.setFilters(model.filters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setPublicIps(model.publicIps);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getPublicIps() {
            return this.publicIps;
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = ValueStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String ... publicIps) {
            this.publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = ValueStringListCopier.copy(publicIps);
        }

        public DescribeMovingAddressesRequest build() {
            return new DescribeMovingAddressesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMovingAddressesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder publicIps(Collection<String> var1);

        public Builder publicIps(String ... var1);
    }
}

