/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.PlacementGroupStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePlacementGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePlacementGroupsRequest> {
    private final List<Filter> filters;
    private final List<String> groupNames;

    private DescribePlacementGroupsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupNames = builder.groupNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsRequest)) {
            return false;
        }
        DescribePlacementGroupsRequest other = (DescribePlacementGroupsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        return other.groupNames() == null || other.groupNames().equals(this.groupNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsRequest model) {
            this.setFilters(model.filters);
            this.setGroupNames(model.groupNames);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
        }

        public DescribePlacementGroupsRequest build() {
            return new DescribePlacementGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePlacementGroupsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);
    }
}

