/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotFleetInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSpotFleetInstancesRequest> {
    private final Integer maxResults;
    private final String nextToken;
    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesRequest(BuilderImpl builder) {
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesRequest)) {
            return false;
        }
        DescribeSpotFleetInstancesRequest other = (DescribeSpotFleetInstancesRequest)((Object)obj);
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        return other.spotFleetRequestId() == null || other.spotFleetRequestId().equals(this.spotFleetRequestId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesRequest model) {
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setSpotFleetRequestId(model.spotFleetRequestId);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public DescribeSpotFleetInstancesRequest build() {
            return new DescribeSpotFleetInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotFleetInstancesRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);
    }
}

