/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddress;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NatGatewayState;
import software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NatGateway
implements ToCopyableBuilder<Builder, NatGateway> {
    private final Instant createTime;
    private final Instant deleteTime;
    private final String failureCode;
    private final String failureMessage;
    private final List<NatGatewayAddress> natGatewayAddresses;
    private final String natGatewayId;
    private final ProvisionedBandwidth provisionedBandwidth;
    private final String state;
    private final String subnetId;
    private final String vpcId;

    private NatGateway(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.natGatewayAddresses = builder.natGatewayAddresses;
        this.natGatewayId = builder.natGatewayId;
        this.provisionedBandwidth = builder.provisionedBandwidth;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant deleteTime() {
        return this.deleteTime;
    }

    public String failureCode() {
        return this.failureCode;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public List<NatGatewayAddress> natGatewayAddresses() {
        return this.natGatewayAddresses;
    }

    public String natGatewayId() {
        return this.natGatewayId;
    }

    public ProvisionedBandwidth provisionedBandwidth() {
        return this.provisionedBandwidth;
    }

    public String state() {
        return this.state;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.deleteTime() == null ? 0 : this.deleteTime().hashCode());
        hashCode = 31 * hashCode + (this.failureCode() == null ? 0 : this.failureCode().hashCode());
        hashCode = 31 * hashCode + (this.failureMessage() == null ? 0 : this.failureMessage().hashCode());
        hashCode = 31 * hashCode + (this.natGatewayAddresses() == null ? 0 : this.natGatewayAddresses().hashCode());
        hashCode = 31 * hashCode + (this.natGatewayId() == null ? 0 : this.natGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.provisionedBandwidth() == null ? 0 : this.provisionedBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGateway)) {
            return false;
        }
        NatGateway other = (NatGateway)obj;
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.deleteTime() == null ^ this.deleteTime() == null) {
            return false;
        }
        if (other.deleteTime() != null && !other.deleteTime().equals(this.deleteTime())) {
            return false;
        }
        if (other.failureCode() == null ^ this.failureCode() == null) {
            return false;
        }
        if (other.failureCode() != null && !other.failureCode().equals(this.failureCode())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        if (other.failureMessage() != null && !other.failureMessage().equals(this.failureMessage())) {
            return false;
        }
        if (other.natGatewayAddresses() == null ^ this.natGatewayAddresses() == null) {
            return false;
        }
        if (other.natGatewayAddresses() != null && !other.natGatewayAddresses().equals(this.natGatewayAddresses())) {
            return false;
        }
        if (other.natGatewayId() == null ^ this.natGatewayId() == null) {
            return false;
        }
        if (other.natGatewayId() != null && !other.natGatewayId().equals(this.natGatewayId())) {
            return false;
        }
        if (other.provisionedBandwidth() == null ^ this.provisionedBandwidth() == null) {
            return false;
        }
        if (other.provisionedBandwidth() != null && !other.provisionedBandwidth().equals(this.provisionedBandwidth())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.deleteTime() != null) {
            sb.append("DeleteTime: ").append(this.deleteTime()).append(",");
        }
        if (this.failureCode() != null) {
            sb.append("FailureCode: ").append(this.failureCode()).append(",");
        }
        if (this.failureMessage() != null) {
            sb.append("FailureMessage: ").append(this.failureMessage()).append(",");
        }
        if (this.natGatewayAddresses() != null) {
            sb.append("NatGatewayAddresses: ").append(this.natGatewayAddresses()).append(",");
        }
        if (this.natGatewayId() != null) {
            sb.append("NatGatewayId: ").append(this.natGatewayId()).append(",");
        }
        if (this.provisionedBandwidth() != null) {
            sb.append("ProvisionedBandwidth: ").append(this.provisionedBandwidth()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant deleteTime;
        private String failureCode;
        private String failureMessage;
        private List<NatGatewayAddress> natGatewayAddresses;
        private String natGatewayId;
        private ProvisionedBandwidth provisionedBandwidth;
        private String state;
        private String subnetId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGateway model) {
            this.setCreateTime(model.createTime);
            this.setDeleteTime(model.deleteTime);
            this.setFailureCode(model.failureCode);
            this.setFailureMessage(model.failureMessage);
            this.setNatGatewayAddresses(model.natGatewayAddresses);
            this.setNatGatewayId(model.natGatewayId);
            this.setProvisionedBandwidth(model.provisionedBandwidth);
            this.setState(model.state);
            this.setSubnetId(model.subnetId);
            this.setVpcId(model.vpcId);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final Collection<NatGatewayAddress> getNatGatewayAddresses() {
            return this.natGatewayAddresses;
        }

        @Override
        public final Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(NatGatewayAddress ... natGatewayAddresses) {
            this.natGatewayAddresses(Arrays.asList(natGatewayAddresses));
            return this;
        }

        public final void setNatGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final ProvisionedBandwidth getProvisionedBandwidth() {
            return this.provisionedBandwidth;
        }

        @Override
        public final Builder provisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth;
            return this;
        }

        public final void setProvisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NatGatewayState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NatGateway build() {
            return new NatGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NatGateway> {
        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder natGatewayAddresses(Collection<NatGatewayAddress> var1);

        public Builder natGatewayAddresses(NatGatewayAddress ... var1);

        public Builder natGatewayId(String var1);

        public Builder provisionedBandwidth(ProvisionedBandwidth var1);

        public Builder state(String var1);

        public Builder state(NatGatewayState var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);
    }
}

