/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.S3Storage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Storage
implements ToCopyableBuilder<Builder, Storage> {
    private final S3Storage s3;

    private Storage(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    public S3Storage s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.s3() == null ? 0 : this.s3().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Storage)) {
            return false;
        }
        Storage other = (Storage)obj;
        if (other.s3() == null ^ this.s3() == null) {
            return false;
        }
        return other.s3() == null || other.s3().equals(this.s3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.s3() != null) {
            sb.append("S3: ").append(this.s3()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private S3Storage s3;

        private BuilderImpl() {
        }

        private BuilderImpl(Storage model) {
            this.setS3(model.s3);
        }

        public final S3Storage getS3() {
            return this.s3;
        }

        @Override
        public final Builder s3(S3Storage s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Storage s3) {
            this.s3 = s3;
        }

        public Storage build() {
            return new Storage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Storage> {
        public Builder s3(S3Storage var1);
    }
}

