/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.S3Storage;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.util.StringUtils;

public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        S3Storage s3;
        Storage storage;
        if (bundleInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)bundleInstanceRequest, "EC2Client");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (bundleInstanceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)bundleInstanceRequest.instanceId()));
        }
        if ((storage = bundleInstanceRequest.storage()) != null && (s3 = storage.s3()) != null) {
            if (s3.awsAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString((String)s3.awsAccessKeyId()));
            }
            if (s3.bucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString((String)s3.bucket()));
            }
            if (s3.prefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString((String)s3.prefix()));
            }
            if (s3.uploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString((String)s3.uploadPolicy()));
            }
            if (s3.uploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString((String)s3.uploadPolicySignature()));
            }
        }
        return request;
    }
}

