/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.util.StringUtils;

public class CancelBundleTaskRequestMarshaller
implements Marshaller<Request<CancelBundleTaskRequest>, CancelBundleTaskRequest> {
    public Request<CancelBundleTaskRequest> marshall(CancelBundleTaskRequest cancelBundleTaskRequest) {
        if (cancelBundleTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelBundleTaskRequest, "EC2Client");
        request.addParameter("Action", "CancelBundleTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelBundleTaskRequest.bundleId() != null) {
            request.addParameter("BundleId", StringUtils.fromString((String)cancelBundleTaskRequest.bundleId()));
        }
        return request;
    }
}

