/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.util.StringUtils;

public class CopyImageRequestMarshaller
implements Marshaller<Request<CopyImageRequest>, CopyImageRequest> {
    public Request<CopyImageRequest> marshall(CopyImageRequest copyImageRequest) {
        if (copyImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyImageRequest, "EC2Client");
        request.addParameter("Action", "CopyImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)copyImageRequest.clientToken()));
        }
        if (copyImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)copyImageRequest.description()));
        }
        if (copyImageRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)copyImageRequest.encrypted()));
        }
        if (copyImageRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyImageRequest.kmsKeyId()));
        }
        if (copyImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)copyImageRequest.name()));
        }
        if (copyImageRequest.sourceImageId() != null) {
            request.addParameter("SourceImageId", StringUtils.fromString((String)copyImageRequest.sourceImageId()));
        }
        if (copyImageRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyImageRequest.sourceRegion()));
        }
        return request;
    }
}

