/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        if (createRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRouteRequest, "EC2Client");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)createRouteRequest.destinationCidrBlock()));
        }
        if (createRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)createRouteRequest.destinationIpv6CidrBlock()));
        }
        if (createRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString((String)createRouteRequest.egressOnlyInternetGatewayId()));
        }
        if (createRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString((String)createRouteRequest.gatewayId()));
        }
        if (createRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createRouteRequest.instanceId()));
        }
        if (createRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString((String)createRouteRequest.natGatewayId()));
        }
        if (createRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)createRouteRequest.networkInterfaceId()));
        }
        if (createRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)createRouteRequest.routeTableId()));
        }
        if (createRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)createRouteRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

