/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeStaleSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeStaleSecurityGroupsRequest>, DescribeStaleSecurityGroupsRequest> {
    public Request<DescribeStaleSecurityGroupsRequest> marshall(DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest) {
        if (describeStaleSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStaleSecurityGroupsRequest, "EC2Client");
        request.addParameter("Action", "DescribeStaleSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStaleSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeStaleSecurityGroupsRequest.maxResults()));
        }
        if (describeStaleSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeStaleSecurityGroupsRequest.nextToken()));
        }
        if (describeStaleSecurityGroupsRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)describeStaleSecurityGroupsRequest.vpcId()));
        }
        return request;
    }
}

