/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DetachVolumeRequestMarshaller
implements Marshaller<Request<DetachVolumeRequest>, DetachVolumeRequest> {
    public Request<DetachVolumeRequest> marshall(DetachVolumeRequest detachVolumeRequest) {
        if (detachVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachVolumeRequest, "EC2Client");
        request.addParameter("Action", "DetachVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachVolumeRequest.device() != null) {
            request.addParameter("Device", StringUtils.fromString((String)detachVolumeRequest.device()));
        }
        if (detachVolumeRequest.force() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)detachVolumeRequest.force()));
        }
        if (detachVolumeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)detachVolumeRequest.instanceId()));
        }
        if (detachVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)detachVolumeRequest.volumeId()));
        }
        return request;
    }
}

