/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.transform.IpRangeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.Ipv6RangeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PrefixListIdUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UserIdGroupPairUnmarshaller;

public class IpPermissionUnmarshaller
implements Unmarshaller<IpPermission, StaxUnmarshallerContext> {
    private static final IpPermissionUnmarshaller INSTANCE = new IpPermissionUnmarshaller();

    public IpPermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        IpPermission.Builder ipPermission;
        block14: {
            ipPermission = IpPermission.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Ipv6Range> ipv6Ranges = null;
            ArrayList<PrefixListId> prefixListIds = null;
            ArrayList<UserIdGroupPair> userIdGroupPairs = null;
            ArrayList<IpRange> ipv4Ranges = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    ipPermission.ipv6Ranges(ipv6Ranges);
                    ipPermission.prefixListIds(prefixListIds);
                    ipPermission.userIdGroupPairs(userIdGroupPairs);
                    ipPermission.ipv4Ranges(ipv4Ranges);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("fromPort", targetDepth)) {
                        ipPermission.fromPort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipProtocol", targetDepth)) {
                        ipPermission.ipProtocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipv6Ranges", targetDepth)) {
                        ipv6Ranges = new ArrayList<Ipv6Range>();
                        continue;
                    }
                    if (context.testExpression("ipv6Ranges/item", targetDepth)) {
                        ipv6Ranges.add(Ipv6RangeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("prefixListIds", targetDepth)) {
                        prefixListIds = new ArrayList<PrefixListId>();
                        continue;
                    }
                    if (context.testExpression("prefixListIds/item", targetDepth)) {
                        prefixListIds.add(PrefixListIdUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("toPort", targetDepth)) {
                        ipPermission.toPort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groups", targetDepth)) {
                        userIdGroupPairs = new ArrayList<UserIdGroupPair>();
                        continue;
                    }
                    if (context.testExpression("groups/item", targetDepth)) {
                        userIdGroupPairs.add(UserIdGroupPairUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipRanges", targetDepth)) {
                        ipv4Ranges = new ArrayList<IpRange>();
                        continue;
                    }
                    if (!context.testExpression("ipRanges/item", targetDepth)) continue;
                    ipv4Ranges.add(IpRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            ipPermission.ipv6Ranges(ipv6Ranges);
            ipPermission.prefixListIds(prefixListIds);
            ipPermission.userIdGroupPairs(userIdGroupPairs);
            ipPermission.ipv4Ranges(ipv4Ranges);
        }
        return (IpPermission)ipPermission.build();
    }

    public static IpPermissionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

