/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class RebootInstancesRequestMarshaller
implements Marshaller<Request<RebootInstancesRequest>, RebootInstancesRequest> {
    public Request<RebootInstancesRequest> marshall(RebootInstancesRequest rebootInstancesRequest) {
        if (rebootInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootInstancesRequest, "EC2Client");
        request.addParameter("Action", "RebootInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> rebootInstancesRequestInstanceIdsList = rebootInstancesRequest.instanceIds();
        if (rebootInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String rebootInstancesRequestInstanceIdsListValue : rebootInstancesRequestInstanceIdsList) {
                if (rebootInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)rebootInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

