/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResetImageAttributeRequestMarshaller
implements Marshaller<Request<ResetImageAttributeRequest>, ResetImageAttributeRequest> {
    public Request<ResetImageAttributeRequest> marshall(ResetImageAttributeRequest resetImageAttributeRequest) {
        if (resetImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ResetImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)resetImageAttributeRequest.attribute()));
        }
        if (resetImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)resetImageAttributeRequest.imageId()));
        }
        return request;
    }
}

