/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;

public class SpotPlacementUnmarshaller
implements Unmarshaller<SpotPlacement, StaxUnmarshallerContext> {
    private static final SpotPlacementUnmarshaller INSTANCE = new SpotPlacementUnmarshaller();

    public SpotPlacement unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SpotPlacement.Builder spotPlacement = SpotPlacement.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("availabilityZone", targetDepth)) {
                    spotPlacement.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupName", targetDepth)) {
                    spotPlacement.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("tenancy", targetDepth)) continue;
                spotPlacement.tenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SpotPlacement)spotPlacement.build();
    }

    public static SpotPlacementUnmarshaller getInstance() {
        return INSTANCE;
    }
}

