/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AllocateAddress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllocateAddressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AllocateAddressRequest.Builder, AllocateAddressRequest> {
    private final String domain;

    private AllocateAddressRequest(BuilderImpl builder) {
        this.domain = builder.domain;
    }

    /**
     * <p>
     * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
     * </p>
     * <p>
     * Default: The address is for use with instances in EC2-Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainString}.
     * </p>
     * 
     * @return Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
     *         <p>
     *         Default: The address is for use with instances in EC2-Classic.
     * @see DomainType
     */
    public DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
     * </p>
     * <p>
     * Default: The address is for use with instances in EC2-Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainString}.
     * </p>
     * 
     * @return Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
     *         <p>
     *         Default: The address is for use with instances in EC2-Classic.
     * @see DomainType
     */
    public String domainString() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainString() == null) ? 0 : domainString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest) obj;
        if (other.domainString() == null ^ this.domainString() == null) {
            return false;
        }
        if (other.domainString() != null && !other.domainString().equals(this.domainString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainString() != null) {
            sb.append("Domain: ").append(domainString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.of(clazz.cast(domainString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AllocateAddressRequest> {
        /**
         * <p>
         * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
         * </p>
         * <p>
         * Default: The address is for use with instances in EC2-Classic.
         * </p>
         * 
         * @param domain
         *        Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
         *        <p>
         *        Default: The address is for use with instances in EC2-Classic.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
         * </p>
         * <p>
         * Default: The address is for use with instances in EC2-Classic.
         * </p>
         * 
         * @param domain
         *        Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
         *        <p>
         *        Default: The address is for use with instances in EC2-Classic.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            domain(model.domain);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }
    }
}
