/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociateVpcCidrBlockResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssociateVpcCidrBlockResponse.Builder, AssociateVpcCidrBlockResponse> {
    private final VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

    private final String vpcId;

    private AssociateVpcCidrBlockResponse(BuilderImpl builder) {
        this.ipv6CidrBlockAssociation = builder.ipv6CidrBlockAssociation;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR block association.
     * </p>
     * 
     * @return Information about the IPv6 CIDR block association.
     */
    public VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation() {
        return ipv6CidrBlockAssociation;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ipv6CidrBlockAssociation() == null) ? 0 : ipv6CidrBlockAssociation().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockResponse)) {
            return false;
        }
        AssociateVpcCidrBlockResponse other = (AssociateVpcCidrBlockResponse) obj;
        if (other.ipv6CidrBlockAssociation() == null ^ this.ipv6CidrBlockAssociation() == null) {
            return false;
        }
        if (other.ipv6CidrBlockAssociation() != null && !other.ipv6CidrBlockAssociation().equals(this.ipv6CidrBlockAssociation())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ipv6CidrBlockAssociation() != null) {
            sb.append("Ipv6CidrBlockAssociation: ").append(ipv6CidrBlockAssociation()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6CidrBlockAssociation":
            return Optional.of(clazz.cast(ipv6CidrBlockAssociation()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AssociateVpcCidrBlockResponse> {
        /**
         * <p>
         * Information about the IPv6 CIDR block association.
         * </p>
         * 
         * @param ipv6CidrBlockAssociation
         *        Information about the IPv6 CIDR block association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockResponse model) {
            ipv6CidrBlockAssociation(model.ipv6CidrBlockAssociation);
            vpcId(model.vpcId);
        }

        public final VpcIpv6CidrBlockAssociation.Builder getIpv6CidrBlockAssociation() {
            return ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation;
            return this;
        }

        public final void setIpv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation.BuilderImpl ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.build() : null;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public AssociateVpcCidrBlockResponse build() {
            return new AssociateVpcCidrBlockResponse(this);
        }
    }
}
