/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AuthorizeSecurityGroupIngress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AuthorizeSecurityGroupIngressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AuthorizeSecurityGroupIngressRequest.Builder, AuthorizeSecurityGroupIngressRequest> {
    private final String cidrIp;

    private final Integer fromPort;

    private final String groupId;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private final String ipProtocol;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private final Integer toPort;

    private AuthorizeSecurityGroupIngressRequest(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ipProtocol = builder.ipProtocol;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
        this.toPort = builder.toPort;
    }

    /**
     * <p>
     * The CIDR IPv4 address range. You can't specify this parameter when specifying a source security group.
     * </p>
     * 
     * @return The CIDR IPv4 address range. You can't specify this parameter when specifying a source security group.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. For the ICMP/ICMPv6 type
     * number, use <code>-1</code> to specify all types.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. For the ICMP/ICMPv6
     *         type number, use <code>-1</code> to specify all types.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The ID of the security group. Required for a nondefault VPC.
     * </p>
     * 
     * @return The ID of the security group. Required for a nondefault VPC.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the security group.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * A set of IP permissions. Can be used to specify multiple rules in a single command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of IP permissions. Can be used to specify multiple rules in a single command.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). (VPC only)
     * Use <code>-1</code> to specify all protocols. If you specify <code>-1</code>, or a protocol number other than
     * <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>58</code> (ICMPv6), traffic on all ports is
     * allowed, regardless of any ports you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you
     * must specify a port range. For protocol <code>58</code> (ICMPv6), you can optionally specify a port range; if you
     * don't, traffic for all types and codes is allowed.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     *         (VPC only) Use <code>-1</code> to specify all protocols. If you specify <code>-1</code>, or a protocol
     *         number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>58</code> (ICMPv6),
     *         traffic on all ports is allowed, regardless of any ports you specify. For <code>tcp</code>,
     *         <code>udp</code>, and <code>icmp</code>, you must specify a port range. For protocol <code>58</code>
     *         (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and codes is
     *         allowed.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination
     * with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the
     * end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific
     * IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be
     * in the same VPC.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
     *         combination with the following parameters: the CIDR IP address range, the start of the port range, the IP
     *         protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To
     *         create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For
     *         EC2-VPC, the source security group must be in the same VPC.
     */
    public String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * [EC2-Classic] The AWS account number for the source security group, if the source security group is in a
     * different account. You can't specify this parameter in combination with the following parameters: the CIDR IP
     * address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that
     * grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of
     * IP permissions instead.
     * </p>
     * 
     * @return [EC2-Classic] The AWS account number for the source security group, if the source security group is in a
     *         different account. You can't specify this parameter in combination with the following parameters: the
     *         CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range.
     *         Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and
     *         port range, use a set of IP permissions instead.
     */
    public String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code number. For the ICMP/ICMPv6 code
     * number, use <code>-1</code> to specify all codes.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code number. For the ICMP/ICMPv6
     *         code number, use <code>-1</code> to specify all codes.
     */
    public Integer toPort() {
        return toPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrIp() == null) ? 0 : cidrIp().hashCode());
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((groupId() == null) ? 0 : groupId().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((ipPermissions() == null) ? 0 : ipPermissions().hashCode());
        hashCode = 31 * hashCode + ((ipProtocol() == null) ? 0 : ipProtocol().hashCode());
        hashCode = 31 * hashCode + ((sourceSecurityGroupName() == null) ? 0 : sourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + ((sourceSecurityGroupOwnerId() == null) ? 0 : sourceSecurityGroupOwnerId().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupIngressRequest other = (AuthorizeSecurityGroupIngressRequest) obj;
        if (other.cidrIp() == null ^ this.cidrIp() == null) {
            return false;
        }
        if (other.cidrIp() != null && !other.cidrIp().equals(this.cidrIp())) {
            return false;
        }
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.ipPermissions() == null ^ this.ipPermissions() == null) {
            return false;
        }
        if (other.ipPermissions() != null && !other.ipPermissions().equals(this.ipPermissions())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.sourceSecurityGroupName() == null ^ this.sourceSecurityGroupName() == null) {
            return false;
        }
        if (other.sourceSecurityGroupName() != null && !other.sourceSecurityGroupName().equals(this.sourceSecurityGroupName())) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() == null ^ this.sourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() != null
                && !other.sourceSecurityGroupOwnerId().equals(this.sourceSecurityGroupOwnerId())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cidrIp() != null) {
            sb.append("CidrIp: ").append(cidrIp()).append(",");
        }
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (ipPermissions() != null) {
            sb.append("IpPermissions: ").append(ipPermissions()).append(",");
        }
        if (ipProtocol() != null) {
            sb.append("IpProtocol: ").append(ipProtocol()).append(",");
        }
        if (sourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: ").append(sourceSecurityGroupName()).append(",");
        }
        if (sourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: ").append(sourceSecurityGroupOwnerId()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.of(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "IpPermissions":
            return Optional.of(clazz.cast(ipPermissions()));
        case "IpProtocol":
            return Optional.of(clazz.cast(ipProtocol()));
        case "SourceSecurityGroupName":
            return Optional.of(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.of(clazz.cast(sourceSecurityGroupOwnerId()));
        case "ToPort":
            return Optional.of(clazz.cast(toPort()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AuthorizeSecurityGroupIngressRequest> {
        /**
         * <p>
         * The CIDR IPv4 address range. You can't specify this parameter when specifying a source security group.
         * </p>
         * 
         * @param cidrIp
         *        The CIDR IPv4 address range. You can't specify this parameter when specifying a source security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. For the ICMP/ICMPv6
         * type number, use <code>-1</code> to specify all types.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. For the
         *        ICMP/ICMPv6 type number, use <code>-1</code> to specify all types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The ID of the security group. Required for a nondefault VPC.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group. Required for a nondefault VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the security group.
         * </p>
         * 
         * @param groupName
         *        [EC2-Classic, default VPC] The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * A set of IP permissions. Can be used to specify multiple rules in a single command.
         * </p>
         * 
         * @param ipPermissions
         *        A set of IP permissions. Can be used to specify multiple rules in a single command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * A set of IP permissions. Can be used to specify multiple rules in a single command.
         * </p>
         * 
         * @param ipPermissions
         *        A set of IP permissions. Can be used to specify multiple rules in a single command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). (VPC
         * only) Use <code>-1</code> to specify all protocols. If you specify <code>-1</code>, or a protocol number
         * other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>58</code> (ICMPv6), traffic on all
         * ports is allowed, regardless of any ports you specify. For <code>tcp</code>, <code>udp</code>, and
         * <code>icmp</code>, you must specify a port range. For protocol <code>58</code> (ICMPv6), you can optionally
         * specify a port range; if you don't, traffic for all types and codes is allowed.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         *        (VPC only) Use <code>-1</code> to specify all protocols. If you specify <code>-1</code>, or a protocol
         *        number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>58</code> (ICMPv6),
         *        traffic on all ports is allowed, regardless of any ports you specify. For <code>tcp</code>,
         *        <code>udp</code>, and <code>icmp</code>, you must specify a port range. For protocol <code>58</code>
         *        (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and codes is
         *        allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
         * combination with the following parameters: the CIDR IP address range, the start of the port range, the IP
         * protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a
         * rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source
         * security group must be in the same VPC.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
         *        combination with the following parameters: the CIDR IP address range, the start of the port range, the
         *        IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access.
         *        To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For
         *        EC2-VPC, the source security group must be in the same VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * [EC2-Classic] The AWS account number for the source security group, if the source security group is in a
         * different account. You can't specify this parameter in combination with the following parameters: the CIDR IP
         * address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules
         * that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a
         * set of IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        [EC2-Classic] The AWS account number for the source security group, if the source security group is in
         *        a different account. You can't specify this parameter in combination with the following parameters:
         *        the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port
         *        range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP
         *        protocol and port range, use a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code number. For the ICMP/ICMPv6 code
         * number, use <code>-1</code> to specify all codes.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code number. For the
         *        ICMP/ICMPv6 code number, use <code>-1</code> to specify all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private Integer fromPort;

        private String groupId;

        private String groupName;

        private List<IpPermission> ipPermissions;

        private String ipProtocol;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private Integer toPort;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupIngressRequest model) {
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            groupId(model.groupId);
            groupName(model.groupName);
            ipPermissions(model.ipPermissions);
            ipProtocol(model.ipProtocol);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
            toPort(model.toPort);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public AuthorizeSecurityGroupIngressRequest build() {
            return new AuthorizeSecurityGroupIngressRequest(this);
        }
    }
}
