/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelExportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelExportTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelExportTaskRequest.Builder, CancelExportTaskRequest> {
    private final String exportTaskId;

    private CancelExportTaskRequest(BuilderImpl builder) {
        this.exportTaskId = builder.exportTaskId;
    }

    /**
     * <p>
     * The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.
     * </p>
     * 
     * @return The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.
     */
    public String exportTaskId() {
        return exportTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportTaskId() == null) ? 0 : exportTaskId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelExportTaskRequest)) {
            return false;
        }
        CancelExportTaskRequest other = (CancelExportTaskRequest) obj;
        if (other.exportTaskId() == null ^ this.exportTaskId() == null) {
            return false;
        }
        if (other.exportTaskId() != null && !other.exportTaskId().equals(this.exportTaskId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exportTaskId() != null) {
            sb.append("ExportTaskId: ").append(exportTaskId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTaskId":
            return Optional.of(clazz.cast(exportTaskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelExportTaskRequest> {
        /**
         * <p>
         * The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.
         * </p>
         * 
         * @param exportTaskId
         *        The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskId(String exportTaskId);
    }

    static final class BuilderImpl implements Builder {
        private String exportTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelExportTaskRequest model) {
            exportTaskId(model.exportTaskId);
        }

        public final String getExportTaskId() {
            return exportTaskId;
        }

        @Override
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        @Override
        public CancelExportTaskRequest build() {
            return new CancelExportTaskRequest(this);
        }
    }
}
