/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a conversion task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConversionTask implements ToCopyableBuilder<ConversionTask.Builder, ConversionTask> {
    private final String conversionTaskId;

    private final String expirationTime;

    private final ImportInstanceTaskDetails importInstance;

    private final ImportVolumeTaskDetails importVolume;

    private final String state;

    private final String statusMessage;

    private final List<Tag> tags;

    private ConversionTask(BuilderImpl builder) {
        this.conversionTaskId = builder.conversionTaskId;
        this.expirationTime = builder.expirationTime;
        this.importInstance = builder.importInstance;
        this.importVolume = builder.importVolume;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the conversion task.
     * </p>
     * 
     * @return The ID of the conversion task.
     */
    public String conversionTaskId() {
        return conversionTaskId;
    }

    /**
     * <p>
     * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel
     * the task.
     * </p>
     * 
     * @return The time when the task expires. If the upload isn't complete before the expiration time, we automatically
     *         cancel the task.
     */
    public String expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * If the task is for importing an instance, this contains information about the import instance task.
     * </p>
     * 
     * @return If the task is for importing an instance, this contains information about the import instance task.
     */
    public ImportInstanceTaskDetails importInstance() {
        return importInstance;
    }

    /**
     * <p>
     * If the task is for importing a volume, this contains information about the import volume task.
     * </p>
     * 
     * @return If the task is for importing a volume, this contains information about the import volume task.
     */
    public ImportVolumeTaskDetails importVolume() {
        return importVolume;
    }

    /**
     * <p>
     * The state of the conversion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConversionTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the conversion task.
     * @see ConversionTaskState
     */
    public ConversionTaskState state() {
        return ConversionTaskState.fromValue(state);
    }

    /**
     * <p>
     * The state of the conversion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConversionTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the conversion task.
     * @see ConversionTaskState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The status message related to the conversion task.
     * </p>
     * 
     * @return The status message related to the conversion task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Any tags assigned to the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the task.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((conversionTaskId() == null) ? 0 : conversionTaskId().hashCode());
        hashCode = 31 * hashCode + ((expirationTime() == null) ? 0 : expirationTime().hashCode());
        hashCode = 31 * hashCode + ((importInstance() == null) ? 0 : importInstance().hashCode());
        hashCode = 31 * hashCode + ((importVolume() == null) ? 0 : importVolume().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTask)) {
            return false;
        }
        ConversionTask other = (ConversionTask) obj;
        if (other.conversionTaskId() == null ^ this.conversionTaskId() == null) {
            return false;
        }
        if (other.conversionTaskId() != null && !other.conversionTaskId().equals(this.conversionTaskId())) {
            return false;
        }
        if (other.expirationTime() == null ^ this.expirationTime() == null) {
            return false;
        }
        if (other.expirationTime() != null && !other.expirationTime().equals(this.expirationTime())) {
            return false;
        }
        if (other.importInstance() == null ^ this.importInstance() == null) {
            return false;
        }
        if (other.importInstance() != null && !other.importInstance().equals(this.importInstance())) {
            return false;
        }
        if (other.importVolume() == null ^ this.importVolume() == null) {
            return false;
        }
        if (other.importVolume() != null && !other.importVolume().equals(this.importVolume())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (conversionTaskId() != null) {
            sb.append("ConversionTaskId: ").append(conversionTaskId()).append(",");
        }
        if (expirationTime() != null) {
            sb.append("ExpirationTime: ").append(expirationTime()).append(",");
        }
        if (importInstance() != null) {
            sb.append("ImportInstance: ").append(importInstance()).append(",");
        }
        if (importVolume() != null) {
            sb.append("ImportVolume: ").append(importVolume()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTaskId":
            return Optional.of(clazz.cast(conversionTaskId()));
        case "ExpirationTime":
            return Optional.of(clazz.cast(expirationTime()));
        case "ImportInstance":
            return Optional.of(clazz.cast(importInstance()));
        case "ImportVolume":
            return Optional.of(clazz.cast(importVolume()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ConversionTask> {
        /**
         * <p>
         * The ID of the conversion task.
         * </p>
         * 
         * @param conversionTaskId
         *        The ID of the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskId(String conversionTaskId);

        /**
         * <p>
         * The time when the task expires. If the upload isn't complete before the expiration time, we automatically
         * cancel the task.
         * </p>
         * 
         * @param expirationTime
         *        The time when the task expires. If the upload isn't complete before the expiration time, we
         *        automatically cancel the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(String expirationTime);

        /**
         * <p>
         * If the task is for importing an instance, this contains information about the import instance task.
         * </p>
         * 
         * @param importInstance
         *        If the task is for importing an instance, this contains information about the import instance task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importInstance(ImportInstanceTaskDetails importInstance);

        /**
         * <p>
         * If the task is for importing a volume, this contains information about the import volume task.
         * </p>
         * 
         * @param importVolume
         *        If the task is for importing a volume, this contains information about the import volume task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importVolume(ImportVolumeTaskDetails importVolume);

        /**
         * <p>
         * The state of the conversion task.
         * </p>
         * 
         * @param state
         *        The state of the conversion task.
         * @see ConversionTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionTaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the conversion task.
         * </p>
         * 
         * @param state
         *        The state of the conversion task.
         * @see ConversionTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionTaskState
         */
        Builder state(ConversionTaskState state);

        /**
         * <p>
         * The status message related to the conversion task.
         * </p>
         * 
         * @param statusMessage
         *        The status message related to the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Any tags assigned to the task.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the task.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String conversionTaskId;

        private String expirationTime;

        private ImportInstanceTaskDetails importInstance;

        private ImportVolumeTaskDetails importVolume;

        private String state;

        private String statusMessage;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionTask model) {
            conversionTaskId(model.conversionTaskId);
            expirationTime(model.expirationTime);
            importInstance(model.importInstance);
            importVolume(model.importVolume);
            state(model.state);
            statusMessage(model.statusMessage);
            tags(model.tags);
        }

        public final String getConversionTaskId() {
            return conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final ImportInstanceTaskDetails.Builder getImportInstance() {
            return importInstance != null ? importInstance.toBuilder() : null;
        }

        @Override
        public final Builder importInstance(ImportInstanceTaskDetails importInstance) {
            this.importInstance = importInstance;
            return this;
        }

        public final void setImportInstance(ImportInstanceTaskDetails.BuilderImpl importInstance) {
            this.importInstance = importInstance != null ? importInstance.build() : null;
        }

        public final ImportVolumeTaskDetails.Builder getImportVolume() {
            return importVolume != null ? importVolume.toBuilder() : null;
        }

        @Override
        public final Builder importVolume(ImportVolumeTaskDetails importVolume) {
            this.importVolume = importVolume;
            return this;
        }

        public final void setImportVolume(ImportVolumeTaskDetails.BuilderImpl importVolume) {
            this.importVolume = importVolume != null ? importVolume.build() : null;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConversionTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ConversionTask build() {
            return new ConversionTask(this);
        }
    }
}
