/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFpgaImageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateFpgaImageResponse.Builder, CreateFpgaImageResponse> {
    private final String fpgaImageId;

    private final String fpgaImageGlobalId;

    private CreateFpgaImageResponse(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
    }

    /**
     * <p>
     * The FPGA image identifier (AFI ID).
     * </p>
     * 
     * @return The FPGA image identifier (AFI ID).
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The global FPGA image identifier (AGFI ID).
     * </p>
     * 
     * @return The global FPGA image identifier (AGFI ID).
     */
    public String fpgaImageGlobalId() {
        return fpgaImageGlobalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fpgaImageId() == null) ? 0 : fpgaImageId().hashCode());
        hashCode = 31 * hashCode + ((fpgaImageGlobalId() == null) ? 0 : fpgaImageGlobalId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageResponse)) {
            return false;
        }
        CreateFpgaImageResponse other = (CreateFpgaImageResponse) obj;
        if (other.fpgaImageId() == null ^ this.fpgaImageId() == null) {
            return false;
        }
        if (other.fpgaImageId() != null && !other.fpgaImageId().equals(this.fpgaImageId())) {
            return false;
        }
        if (other.fpgaImageGlobalId() == null ^ this.fpgaImageGlobalId() == null) {
            return false;
        }
        if (other.fpgaImageGlobalId() != null && !other.fpgaImageGlobalId().equals(this.fpgaImageGlobalId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(fpgaImageId()).append(",");
        }
        if (fpgaImageGlobalId() != null) {
            sb.append("FpgaImageGlobalId: ").append(fpgaImageGlobalId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        case "FpgaImageGlobalId":
            return Optional.of(clazz.cast(fpgaImageGlobalId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateFpgaImageResponse> {
        /**
         * <p>
         * The FPGA image identifier (AFI ID).
         * </p>
         * 
         * @param fpgaImageId
         *        The FPGA image identifier (AFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The global FPGA image identifier (AGFI ID).
         * </p>
         * 
         * @param fpgaImageGlobalId
         *        The global FPGA image identifier (AGFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageGlobalId(String fpgaImageGlobalId);
    }

    static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private String fpgaImageGlobalId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageResponse model) {
            fpgaImageId(model.fpgaImageId);
            fpgaImageGlobalId(model.fpgaImageGlobalId);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getFpgaImageGlobalId() {
            return fpgaImageGlobalId;
        }

        @Override
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        @Override
        public CreateFpgaImageResponse build() {
            return new CreateFpgaImageResponse(this);
        }
    }
}
