/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for CreateInstanceExportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstanceExportTaskResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateInstanceExportTaskResponse.Builder, CreateInstanceExportTaskResponse> {
    private final ExportTask exportTask;

    private CreateInstanceExportTaskResponse(BuilderImpl builder) {
        this.exportTask = builder.exportTask;
    }

    /**
     * <p>
     * Information about the instance export task.
     * </p>
     * 
     * @return Information about the instance export task.
     */
    public ExportTask exportTask() {
        return exportTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportTask() == null) ? 0 : exportTask().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskResponse)) {
            return false;
        }
        CreateInstanceExportTaskResponse other = (CreateInstanceExportTaskResponse) obj;
        if (other.exportTask() == null ^ this.exportTask() == null) {
            return false;
        }
        if (other.exportTask() != null && !other.exportTask().equals(this.exportTask())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exportTask() != null) {
            sb.append("ExportTask: ").append(exportTask()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTask":
            return Optional.of(clazz.cast(exportTask()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInstanceExportTaskResponse> {
        /**
         * <p>
         * Information about the instance export task.
         * </p>
         * 
         * @param exportTask
         *        Information about the instance export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTask(ExportTask exportTask);
    }

    static final class BuilderImpl implements Builder {
        private ExportTask exportTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskResponse model) {
            exportTask(model.exportTask);
        }

        public final ExportTask.Builder getExportTask() {
            return exportTask != null ? exportTask.toBuilder() : null;
        }

        @Override
        public final Builder exportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
            return this;
        }

        public final void setExportTask(ExportTask.BuilderImpl exportTask) {
            this.exportTask = exportTask != null ? exportTask.build() : null;
        }

        @Override
        public CreateInstanceExportTaskResponse build() {
            return new CreateInstanceExportTaskResponse(this);
        }
    }
}
