/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the KeyPair object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateKeyPairResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateKeyPairResponse.Builder, CreateKeyPairResponse> {
    private final KeyPair keyPair;

    private CreateKeyPairResponse(BuilderImpl builder) {
        this.keyPair = builder.keyPair;
    }

    /**
     * <p>
     * Describes a key pair.
     * </p>
     * 
     * @return Describes a key pair.
     */
    public KeyPair keyPair() {
        return keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyPair() == null) ? 0 : keyPair().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse) obj;
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        if (other.keyPair() != null && !other.keyPair().equals(this.keyPair())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyPair() != null) {
            sb.append("KeyPair: ").append(keyPair()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPair":
            return Optional.of(clazz.cast(keyPair()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateKeyPairResponse> {
        /**
         * <p>
         * Describes a key pair.
         * </p>
         * 
         * @param keyPair
         *        Describes a key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);
    }

    static final class BuilderImpl implements Builder {
        private KeyPair keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            keyPair(model.keyPair);
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }
    }
}
