/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateSubnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSubnetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateSubnetResponse.Builder, CreateSubnetResponse> {
    private final Subnet subnet;

    private CreateSubnetResponse(BuilderImpl builder) {
        this.subnet = builder.subnet;
    }

    /**
     * <p>
     * Information about the subnet.
     * </p>
     * 
     * @return Information about the subnet.
     */
    public Subnet subnet() {
        return subnet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subnet() == null) ? 0 : subnet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetResponse)) {
            return false;
        }
        CreateSubnetResponse other = (CreateSubnetResponse) obj;
        if (other.subnet() == null ^ this.subnet() == null) {
            return false;
        }
        if (other.subnet() != null && !other.subnet().equals(this.subnet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (subnet() != null) {
            sb.append("Subnet: ").append(subnet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnet":
            return Optional.of(clazz.cast(subnet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSubnetResponse> {
        /**
         * <p>
         * Information about the subnet.
         * </p>
         * 
         * @param subnet
         *        Information about the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(Subnet subnet);
    }

    static final class BuilderImpl implements Builder {
        private Subnet subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetResponse model) {
            subnet(model.subnet);
        }

        public final Subnet.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(Subnet.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public CreateSubnetResponse build() {
            return new CreateSubnetResponse(this);
        }
    }
}
