/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a customer gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomerGateway implements ToCopyableBuilder<CustomerGateway.Builder, CustomerGateway> {
    private final String bgpAsn;

    private final String customerGatewayId;

    private final String ipAddress;

    private final String state;

    private final String type;

    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     * </p>
     * 
     * @return The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    public String bgpAsn() {
        return bgpAsn;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The Internet-routable IP address of the customer gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the customer gateway's outside interface.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     * </p>
     * 
     * @return The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Any tags assigned to the customer gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the customer gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bgpAsn() == null) ? 0 : bgpAsn().hashCode());
        hashCode = 31 * hashCode + ((customerGatewayId() == null) ? 0 : customerGatewayId().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway) obj;
        if (other.bgpAsn() == null ^ this.bgpAsn() == null) {
            return false;
        }
        if (other.bgpAsn() != null && !other.bgpAsn().equals(this.bgpAsn())) {
            return false;
        }
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bgpAsn() != null) {
            sb.append("BgpAsn: ").append(bgpAsn()).append(",");
        }
        if (customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(customerGatewayId()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IpAddress: ").append(ipAddress()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BgpAsn":
            return Optional.of(clazz.cast(bgpAsn()));
        case "CustomerGatewayId":
            return Optional.of(clazz.cast(customerGatewayId()));
        case "IpAddress":
            return Optional.of(clazz.cast(ipAddress()));
        case "State":
            return Optional.of(clazz.cast(state()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CustomerGateway> {
        /**
         * <p>
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * 
         * @param bgpAsn
         *        The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpAsn(String bgpAsn);

        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The Internet-routable IP address of the customer gateway's outside interface.
         * </p>
         * 
         * @param ipAddress
         *        The Internet-routable IP address of the customer gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * </p>
         * 
         * @param state
         *        The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String bgpAsn;

        private String customerGatewayId;

        private String ipAddress;

        private String state;

        private String type;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            bgpAsn(model.bgpAsn);
            customerGatewayId(model.customerGatewayId);
            ipAddress(model.ipAddress);
            state(model.state);
            type(model.type);
            tags(model.tags);
        }

        public final String getBgpAsn() {
            return bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CustomerGateway build() {
            return new CustomerGateway(this);
        }
    }
}
