/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteInternetGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteInternetGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteInternetGatewayRequest.Builder, DeleteInternetGatewayRequest> {
    private final String internetGatewayId;

    private DeleteInternetGatewayRequest(BuilderImpl builder) {
        this.internetGatewayId = builder.internetGatewayId;
    }

    /**
     * <p>
     * The ID of the Internet gateway.
     * </p>
     * 
     * @return The ID of the Internet gateway.
     */
    public String internetGatewayId() {
        return internetGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((internetGatewayId() == null) ? 0 : internetGatewayId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInternetGatewayRequest)) {
            return false;
        }
        DeleteInternetGatewayRequest other = (DeleteInternetGatewayRequest) obj;
        if (other.internetGatewayId() == null ^ this.internetGatewayId() == null) {
            return false;
        }
        if (other.internetGatewayId() != null && !other.internetGatewayId().equals(this.internetGatewayId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (internetGatewayId() != null) {
            sb.append("InternetGatewayId: ").append(internetGatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGatewayId":
            return Optional.of(clazz.cast(internetGatewayId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteInternetGatewayRequest> {
        /**
         * <p>
         * The ID of the Internet gateway.
         * </p>
         * 
         * @param internetGatewayId
         *        The ID of the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayId(String internetGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String internetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInternetGatewayRequest model) {
            internetGatewayId(model.internetGatewayId);
        }

        public final String getInternetGatewayId() {
            return internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public DeleteInternetGatewayRequest build() {
            return new DeleteInternetGatewayRequest(this);
        }
    }
}
