/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteKeyPair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteKeyPairRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteKeyPairRequest.Builder, DeleteKeyPairRequest> {
    private final String keyName;

    private DeleteKeyPairRequest(BuilderImpl builder) {
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyPairRequest)) {
            return false;
        }
        DeleteKeyPairRequest other = (DeleteKeyPairRequest) obj;
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteKeyPairRequest> {
        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl implements Builder {
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyPairRequest model) {
            keyName(model.keyName);
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public DeleteKeyPairRequest build() {
            return new DeleteKeyPairRequest(this);
        }
    }
}
