/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVpcEndpointsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteVpcEndpointsRequest.Builder, DeleteVpcEndpointsRequest> {
    private final List<String> vpcEndpointIds;

    private DeleteVpcEndpointsRequest(BuilderImpl builder) {
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    /**
     * <p>
     * One or more endpoint IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more endpoint IDs.
     */
    public List<String> vpcEndpointIds() {
        return vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcEndpointIds() == null) ? 0 : vpcEndpointIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsRequest)) {
            return false;
        }
        DeleteVpcEndpointsRequest other = (DeleteVpcEndpointsRequest) obj;
        if (other.vpcEndpointIds() == null ^ this.vpcEndpointIds() == null) {
            return false;
        }
        if (other.vpcEndpointIds() != null && !other.vpcEndpointIds().equals(this.vpcEndpointIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcEndpointIds() != null) {
            sb.append("VpcEndpointIds: ").append(vpcEndpointIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointIds":
            return Optional.of(clazz.cast(vpcEndpointIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteVpcEndpointsRequest> {
        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(Collection<String> vpcEndpointIds);

        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(String... vpcEndpointIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> vpcEndpointIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsRequest model) {
            vpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getVpcEndpointIds() {
            return vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String... vpcEndpointIds) {
            vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        @Override
        public DeleteVpcEndpointsRequest build() {
            return new DeleteVpcEndpointsRequest(this);
        }
    }
}
