/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAddressesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAddressesRequest.Builder, DescribeAddressesRequest> {
    private final List<Filter> filters;

    private final List<String> publicIps;

    private final List<String> allocationIds;

    private DescribeAddressesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.publicIps = builder.publicIps;
        this.allocationIds = builder.allocationIds;
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association-id</code> - [EC2-VPC] The association ID for the address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a VPC
     * (<code>vpc</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated
     * with, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-owner-id</code> - The AWS account ID of the owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public-ip</code> - The Elastic IP address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association-id</code> - [EC2-VPC] The association ID for the address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or
     *         in a VPC (<code>vpc</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance the address is associated with, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is
     *         associated with, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-owner-id</code> - The AWS account ID of the owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP
     *         address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public-ip</code> - The Elastic IP address.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * [EC2-Classic] One or more Elastic IP addresses.
     * </p>
     * <p>
     * Default: Describes all your Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic] One or more Elastic IP addresses.</p>
     *         <p>
     *         Default: Describes all your Elastic IP addresses.
     */
    public List<String> publicIps() {
        return publicIps;
    }

    /**
     * <p>
     * [EC2-VPC] One or more allocation IDs.
     * </p>
     * <p>
     * Default: Describes all your Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] One or more allocation IDs.</p>
     *         <p>
     *         Default: Describes all your Elastic IP addresses.
     */
    public List<String> allocationIds() {
        return allocationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((publicIps() == null) ? 0 : publicIps().hashCode());
        hashCode = 31 * hashCode + ((allocationIds() == null) ? 0 : allocationIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.publicIps() == null ^ this.publicIps() == null) {
            return false;
        }
        if (other.publicIps() != null && !other.publicIps().equals(this.publicIps())) {
            return false;
        }
        if (other.allocationIds() == null ^ this.allocationIds() == null) {
            return false;
        }
        if (other.allocationIds() != null && !other.allocationIds().equals(this.allocationIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (publicIps() != null) {
            sb.append("PublicIps: ").append(publicIps()).append(",");
        }
        if (allocationIds() != null) {
            sb.append("AllocationIds: ").append(allocationIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "PublicIps":
            return Optional.of(clazz.cast(publicIps()));
        case "AllocationIds":
            return Optional.of(clazz.cast(allocationIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAddressesRequest> {
        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association-id</code> - [EC2-VPC] The association ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a
         * VPC (<code>vpc</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated
         * with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-owner-id</code> - The AWS account ID of the owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public-ip</code> - The Elastic IP address.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association-id</code> - [EC2-VPC] The association ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>)
         *        or in a VPC (<code>vpc</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is
         *        associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-owner-id</code> - The AWS account ID of the owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public-ip</code> - The Elastic IP address.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association-id</code> - [EC2-VPC] The association ID for the address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a
         * VPC (<code>vpc</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated
         * with, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-owner-id</code> - The AWS account ID of the owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public-ip</code> - The Elastic IP address.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association-id</code> - [EC2-VPC] The association ID for the address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>)
         *        or in a VPC (<code>vpc</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance the address is associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is
         *        associated with, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-owner-id</code> - The AWS account ID of the owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public-ip</code> - The Elastic IP address.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * [EC2-Classic] One or more Elastic IP addresses.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        [EC2-Classic] One or more Elastic IP addresses.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(Collection<String> publicIps);

        /**
         * <p>
         * [EC2-Classic] One or more Elastic IP addresses.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        [EC2-Classic] One or more Elastic IP addresses.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(String... publicIps);

        /**
         * <p>
         * [EC2-VPC] One or more allocation IDs.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param allocationIds
         *        [EC2-VPC] One or more allocation IDs.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(Collection<String> allocationIds);

        /**
         * <p>
         * [EC2-VPC] One or more allocation IDs.
         * </p>
         * <p>
         * Default: Describes all your Elastic IP addresses.
         * </p>
         * 
         * @param allocationIds
         *        [EC2-VPC] One or more allocation IDs.</p>
         *        <p>
         *        Default: Describes all your Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(String... allocationIds);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> publicIps;

        private List<String> allocationIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesRequest model) {
            filters(model.filters);
            publicIps(model.publicIps);
            allocationIds(model.allocationIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getPublicIps() {
            return publicIps;
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String... publicIps) {
            publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
        }

        public final Collection<String> getAllocationIds() {
            return allocationIds;
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String... allocationIds) {
            allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @Override
        public DescribeAddressesRequest build() {
            return new DescribeAddressesRequest(this);
        }
    }
}
