/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFlowLogsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeFlowLogsRequest.Builder, DescribeFlowLogsRequest> {
    private final List<Filter> filter;

    private final List<String> flowLogIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeFlowLogsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.flowLogIds = builder.flowLogIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>flow-log-id</code> - The ID of the flow log.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>log-group-name</code> - The name of the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
     *         <code>FAILED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>flow-log-id</code> - The ID of the flow log.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>log-group-name</code> - The name of the log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
     *         <code>ALL</code>)
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * One or more flow log IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more flow log IDs.
     */
    public List<String> flowLogIds() {
        return flowLogIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if
     * <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You cannot specify
     * this parameter and the flow log IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>NextToken</code> value. This value can be between
     *         5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     *         You cannot specify this parameter and the flow log IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((flowLogIds() == null) ? 0 : flowLogIds().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsRequest)) {
            return false;
        }
        DescribeFlowLogsRequest other = (DescribeFlowLogsRequest) obj;
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.flowLogIds() == null ^ this.flowLogIds() == null) {
            return false;
        }
        if (other.flowLogIds() != null && !other.flowLogIds().equals(this.flowLogIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(flowLogIds()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.of(clazz.cast(filter()));
        case "FlowLogIds":
            return Optional.of(clazz.cast(flowLogIds()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFlowLogsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>flow-log-id</code> - The ID of the flow log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-group-name</code> - The name of the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>
         * )
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
         *        <code>FAILED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>flow-log-id</code> - The ID of the flow log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-group-name</code> - The name of the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
         *        <code>ALL</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>flow-log-id</code> - The ID of the flow log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-group-name</code> - The name of the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>
         * )
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
         *        <code>FAILED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>flow-log-id</code> - The ID of the flow log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-group-name</code> - The name of the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
         *        <code>ALL</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(Collection<String> flowLogIds);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(String... flowLogIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and
         * 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You
         * cannot specify this parameter and the flow log IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>NextToken</code> value. This value can be
         *        between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results
         *        are returned. You cannot specify this parameter and the flow log IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filter;

        private List<String> flowLogIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsRequest model) {
            filter(model.filter);
            flowLogIds(model.flowLogIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilter() {
            return filter != null ? filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Collection<String> getFlowLogIds() {
            return flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String... flowLogIds) {
            flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFlowLogsRequest build() {
            return new DescribeFlowLogsRequest(this);
        }
    }
}
