/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstancesResponse.Builder, DescribeInstancesResponse> {
    private final List<Reservation> reservations;

    private final String nextToken;

    private DescribeInstancesResponse(BuilderImpl builder) {
        this.reservations = builder.reservations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Zero or more reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Zero or more reservations.
     */
    public List<Reservation> reservations() {
        return reservations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservations() == null) ? 0 : reservations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse) obj;
        if (other.reservations() == null ^ this.reservations() == null) {
            return false;
        }
        if (other.reservations() != null && !other.reservations().equals(this.reservations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservations() != null) {
            sb.append("Reservations: ").append(reservations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reservations":
            return Optional.of(clazz.cast(reservations()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancesResponse> {
        /**
         * <p>
         * Zero or more reservations.
         * </p>
         * 
         * @param reservations
         *        Zero or more reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Collection<Reservation> reservations);

        /**
         * <p>
         * Zero or more reservations.
         * </p>
         * 
         * @param reservations
         *        Zero or more reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Reservation... reservations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Reservation> reservations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            reservations(model.reservations);
            nextToken(model.nextToken);
        }

        public final Collection<Reservation.Builder> getReservations() {
            return reservations != null ? reservations.stream().map(Reservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation... reservations) {
            reservations(Arrays.asList(reservations));
            return this;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ReservationListCopier.copyFromBuilder(reservations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }
    }
}
