/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeKeyPairs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeKeyPairsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeKeyPairsResponse.Builder, DescribeKeyPairsResponse> {
    private final List<KeyPairInfo> keyPairs;

    private DescribeKeyPairsResponse(BuilderImpl builder) {
        this.keyPairs = builder.keyPairs;
    }

    /**
     * <p>
     * Information about one or more key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more key pairs.
     */
    public List<KeyPairInfo> keyPairs() {
        return keyPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyPairs() == null) ? 0 : keyPairs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsResponse)) {
            return false;
        }
        DescribeKeyPairsResponse other = (DescribeKeyPairsResponse) obj;
        if (other.keyPairs() == null ^ this.keyPairs() == null) {
            return false;
        }
        if (other.keyPairs() != null && !other.keyPairs().equals(this.keyPairs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyPairs() != null) {
            sb.append("KeyPairs: ").append(keyPairs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPairs":
            return Optional.of(clazz.cast(keyPairs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeKeyPairsResponse> {
        /**
         * <p>
         * Information about one or more key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about one or more key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPairInfo> keyPairs);

        /**
         * <p>
         * Information about one or more key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about one or more key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPairInfo... keyPairs);
    }

    static final class BuilderImpl implements Builder {
        private List<KeyPairInfo> keyPairs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsResponse model) {
            keyPairs(model.keyPairs);
        }

        public final Collection<KeyPairInfo.Builder> getKeyPairs() {
            return keyPairs != null ? keyPairs.stream().map(KeyPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPairInfo> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPairInfo... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPairInfo.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        @Override
        public DescribeKeyPairsResponse build() {
            return new DescribeKeyPairsResponse(this);
        }
    }
}
