/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeMovingAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMovingAddressesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeMovingAddressesRequest.Builder, DescribeMovingAddressesRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> publicIps;

    private DescribeMovingAddressesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.publicIps = builder.publicIps;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
     * <code>RestoringToClassic</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
     *         <code>RestoringToClassic</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results of the initial
     * request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be
     * between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error is returned.
     * </p>
     * <p>
     * Default: If no value is provided, the default is 1000.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results of the
     *         initial request can be seen by sending another request with the returned <code>NextToken</code> value.
     *         This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range,
     *         an error is returned.</p>
     *         <p>
     *         Default: If no value is provided, the default is 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * One or more Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Elastic IP addresses.
     */
    public List<String> publicIps() {
        return publicIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((publicIps() == null) ? 0 : publicIps().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesRequest)) {
            return false;
        }
        DescribeMovingAddressesRequest other = (DescribeMovingAddressesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.publicIps() == null ^ this.publicIps() == null) {
            return false;
        }
        if (other.publicIps() != null && !other.publicIps().equals(this.publicIps())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (publicIps() != null) {
            sb.append("PublicIps: ").append(publicIps()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "PublicIps":
            return Optional.of(clazz.cast(publicIps()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMovingAddressesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
         * <code>RestoringToClassic</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
         *        <code>RestoringToClassic</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
         * <code>RestoringToClassic</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> |
         *        <code>RestoringToClassic</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results of the
         * initial request can be seen by sending another request with the returned <code>NextToken</code> value. This
         * value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error
         * is returned.
         * </p>
         * <p>
         * Default: If no value is provided, the default is 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results of the
         *        initial request can be seen by sending another request with the returned <code>NextToken</code> value.
         *        This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this
         *        range, an error is returned.</p>
         *        <p>
         *        Default: If no value is provided, the default is 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        One or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(Collection<String> publicIps);

        /**
         * <p>
         * One or more Elastic IP addresses.
         * </p>
         * 
         * @param publicIps
         *        One or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIps(String... publicIps);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> publicIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesRequest model) {
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            publicIps(model.publicIps);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getPublicIps() {
            return publicIps;
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = ValueStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String... publicIps) {
            publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = ValueStringListCopier.copy(publicIps);
        }

        @Override
        public DescribeMovingAddressesRequest build() {
            return new DescribeMovingAddressesRequest(this);
        }
    }
}
