/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeNetworkInterfaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfacesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeNetworkInterfacesResponse.Builder, DescribeNetworkInterfacesResponse> {
    private final List<NetworkInterface> networkInterfaces;

    private DescribeNetworkInterfacesResponse(BuilderImpl builder) {
        this.networkInterfaces = builder.networkInterfaces;
    }

    /**
     * <p>
     * Information about one or more network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more network interfaces.
     */
    public List<NetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkInterfaces() == null) ? 0 : networkInterfaces().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesResponse)) {
            return false;
        }
        DescribeNetworkInterfacesResponse other = (DescribeNetworkInterfacesResponse) obj;
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaces":
            return Optional.of(clazz.cast(networkInterfaces()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNetworkInterfacesResponse> {
        /**
         * <p>
         * Information about one or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        Information about one or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces);

        /**
         * <p>
         * Information about one or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        Information about one or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(NetworkInterface... networkInterfaces);
    }

    static final class BuilderImpl implements Builder {
        private List<NetworkInterface> networkInterfaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesResponse model) {
            networkInterfaces(model.networkInterfaces);
        }

        public final Collection<NetworkInterface.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(NetworkInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public DescribeNetworkInterfacesResponse build() {
            return new DescribeNetworkInterfacesResponse(this);
        }
    }
}
