/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesListings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesListingsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeReservedInstancesListingsRequest.Builder, DescribeReservedInstancesListingsRequest> {
    private final List<Filter> filters;

    private final String reservedInstancesId;

    private final String reservedInstancesListingId;

    private DescribeReservedInstancesListingsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> |
     * <code>cancelled</code> | <code>closed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The reason for the status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>reserved-instances-id</code> - The ID of the Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
     *         <code>active</code> | <code>cancelled</code> | <code>closed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The reason for the status.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more Reserved Instance IDs.
     * </p>
     * 
     * @return One or more Reserved Instance IDs.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * One or more Reserved Instance listing IDs.
     * </p>
     * 
     * @return One or more Reserved Instance listing IDs.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesId() == null) ? 0 : reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesListingId() == null) ? 0 : reservedInstancesListingId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsRequest)) {
            return false;
        }
        DescribeReservedInstancesListingsRequest other = (DescribeReservedInstancesListingsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.reservedInstancesListingId() == null ^ this.reservedInstancesListingId() == null) {
            return false;
        }
        if (other.reservedInstancesListingId() != null
                && !other.reservedInstancesListingId().equals(this.reservedInstancesListingId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(reservedInstancesListingId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        case "ReservedInstancesListingId":
            return Optional.of(clazz.cast(reservedInstancesListingId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code>
         * | <code>cancelled</code> | <code>closed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
         *        <code>active</code> | <code>cancelled</code> | <code>closed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code>
         * | <code>cancelled</code> | <code>closed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
         *        <code>active</code> | <code>cancelled</code> | <code>closed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more Reserved Instance IDs.
         * </p>
         * 
         * @param reservedInstancesId
         *        One or more Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * One or more Reserved Instance listing IDs.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        One or more Reserved Instance listing IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private String reservedInstancesId;

        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsRequest model) {
            filters(model.filters);
            reservedInstancesId(model.reservedInstancesId);
            reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public DescribeReservedInstancesListingsRequest build() {
            return new DescribeReservedInstancesListingsRequest(this);
        }
    }
}
