/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSecurityGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecurityGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSecurityGroupsRequest.Builder, DescribeSecurityGroupsRequest> {
    private final List<Filter> filters;

    private final List<String> groupIds;

    private final List<String> groupNames;

    private DescribeSecurityGroupsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
    }

    /**
     * <p>
     * One or more filters. If using multiple filters for rules, the results include security groups for which any
     * combination of rules - not necessarily a single rule - match all filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - The description of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the security group
     * allows access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an ICMP type
     * number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a security group
     * rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> | <code>udp</code> |
     * <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the owner of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. If using multiple filters for rules, the results include security groups for which
     *         any combination of rules - not necessarily a single rule - match all filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the
     *         security group allows access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security group
     *         rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an ICMP
     *         type number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a security
     *         group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> |
     *         <code>udp</code> | <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP
     *         code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the owner of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more security group IDs. Required for security groups in a nondefault VPC.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs. Required for security groups in a nondefault VPC.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public List<String> groupIds() {
        return groupIds;
    }

    /**
     * <p>
     * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security group
     * name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to
     * describe security groups by name.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
     *         group name or the security group ID. For security groups in a nondefault VPC, use the
     *         <code>group-name</code> filter to describe security groups by name.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((groupIds() == null) ? 0 : groupIds().hashCode());
        hashCode = 31 * hashCode + ((groupNames() == null) ? 0 : groupNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsRequest)) {
            return false;
        }
        DescribeSecurityGroupsRequest other = (DescribeSecurityGroupsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.groupIds() == null ^ this.groupIds() == null) {
            return false;
        }
        if (other.groupIds() != null && !other.groupIds().equals(this.groupIds())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (groupIds() != null) {
            sb.append("GroupIds: ").append(groupIds()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "GroupIds":
            return Optional.of(clazz.cast(groupIds()));
        case "GroupNames":
            return Optional.of(clazz.cast(groupNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSecurityGroupsRequest> {
        /**
         * <p>
         * One or more filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the security
         * group allows access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security group
         * rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an ICMP type
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> | <code>udp</code>
         * | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. If using multiple filters for rules, the results include security groups for
         *        which any combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the
         *        security group allows access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security
         *        group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an
         *        ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> |
         *        <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP
         *        code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the security
         * group allows access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security group
         * rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an ICMP type
         * number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> | <code>udp</code>
         * | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. If using multiple filters for rules, the results include security groups for
         *        which any combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the
         *        security group allows access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR range that has been granted permission in a security
         *        group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an
         *        ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR range that has been granted permission in a
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> |
         *        <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP
         *        code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more security group IDs. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * One or more security group IDs. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        /**
         * <p>
         * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] One or more security group names. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] One or more security group names. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> groupIds;

        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsRequest model) {
            filters(model.filters);
            groupIds(model.groupIds);
            groupNames(model.groupNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupIds() {
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @Override
        public DescribeSecurityGroupsRequest build() {
            return new DescribeSecurityGroupsRequest(this);
        }
    }
}
