/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSpotPriceHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotPriceHistoryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSpotPriceHistoryRequest.Builder, DescribeSpotPriceHistoryRequest> {
    private final List<Filter> filters;

    private final String availabilityZone;

    private final Instant endTime;

    private final List<String> instanceTypes;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> productDescriptions;

    private final Instant startTime;

    private DescribeSpotPriceHistoryRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.availabilityZone = builder.availabilityZone;
        this.endTime = builder.endTime;
        this.instanceTypes = builder.instanceTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.productDescriptions = builder.productDescriptions;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
     * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or less
     * than comparison is not supported).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater than or
     * less than comparison is not supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone for which prices should be returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
     *         <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     *         <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
     *         less than comparison is not supported).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
     *         than or less than comparison is not supported.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Filters the results by the specified Availability Zone.
     * </p>
     * 
     * @return Filters the results by the specified Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format
     * (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time, up to the current date, from which to stop retrieving the price history data, in UTC
     *         format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Filters the results by the specified instance types. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified instance types. Note that T2 and HS1 instance types are not
     *         supported.
     */
    public List<InstanceType> instanceTypes() {
        return TypeConverter.convert(instanceTypes, InstanceType::fromValue);
    }

    /**
     * <p>
     * Filters the results by the specified instance types. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified instance types. Note that T2 and HS1 instance types are not
     *         supported.
     */
    public List<String> instanceTypesStrings() {
        return instanceTypes;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value
     * is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
     *         value is 1000. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filters the results by the specified basic product descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified basic product descriptions.
     */
    public List<String> productDescriptions() {
        return productDescriptions;
    }

    /**
     * <p>
     * The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format
     * (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC
     *         format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((instanceTypesStrings() == null) ? 0 : instanceTypesStrings().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((productDescriptions() == null) ? 0 : productDescriptions().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instanceTypesStrings() == null ^ this.instanceTypesStrings() == null) {
            return false;
        }
        if (other.instanceTypesStrings() != null && !other.instanceTypesStrings().equals(this.instanceTypesStrings())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.productDescriptions() == null ^ this.productDescriptions() == null) {
            return false;
        }
        if (other.productDescriptions() != null && !other.productDescriptions().equals(this.productDescriptions())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (instanceTypesStrings() != null) {
            sb.append("InstanceTypes: ").append(instanceTypesStrings()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (productDescriptions() != null) {
            sb.append("ProductDescriptions: ").append(productDescriptions()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        case "InstanceTypes":
            return Optional.of(clazz.cast(instanceTypesStrings()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ProductDescriptions":
            return Optional.of(clazz.cast(productDescriptions()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
         * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
         * less than comparison is not supported).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
         * than or less than comparison is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code>
         *        | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         *        <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than
         *        or less than comparison is not supported).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?).
         *        Greater than or less than comparison is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
         * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
         * less than comparison is not supported).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
         * than or less than comparison is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code>
         *        | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         *        <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than
         *        or less than comparison is not supported).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?).
         *        Greater than or less than comparison is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters the results by the specified Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        Filters the results by the specified Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The date and time, up to the current date, from which to stop retrieving the price history data, in UTC
         * format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param endTime
         *        The date and time, up to the current date, from which to stop retrieving the price history data, in
         *        UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Filters the results by the specified instance types. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types. Note that T2 and HS1 instance types are not
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * Filters the results by the specified instance types. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types. Note that T2 and HS1 instance types are not
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
         * value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 1 and 1000. The
         *        default value is 1000. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters the results by the specified basic product descriptions.
         * </p>
         * 
         * @param productDescriptions
         *        Filters the results by the specified basic product descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescriptions(Collection<String> productDescriptions);

        /**
         * <p>
         * Filters the results by the specified basic product descriptions.
         * </p>
         * 
         * @param productDescriptions
         *        Filters the results by the specified basic product descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescriptions(String... productDescriptions);

        /**
         * <p>
         * The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC
         * format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param startTime
         *        The date and time, up to the past 90 days, from which to start retrieving the price history data, in
         *        UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private String availabilityZone;

        private Instant endTime;

        private List<String> instanceTypes;

        private Integer maxResults;

        private String nextToken;

        private List<String> productDescriptions;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryRequest model) {
            filters(model.filters);
            availabilityZone(model.availabilityZone);
            endTime(model.endTime);
            instanceTypes(model.instanceTypes);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            productDescriptions(model.productDescriptions);
            startTime(model.startTime);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstanceTypes() {
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProductDescriptions() {
            return productDescriptions;
        }

        @Override
        public final Builder productDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productDescriptions(String... productDescriptions) {
            productDescriptions(Arrays.asList(productDescriptions));
            return this;
        }

        public final void setProductDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public DescribeSpotPriceHistoryRequest build() {
            return new DescribeSpotPriceHistoryRequest(this);
        }
    }
}
