/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeTags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeTagsRequest.Builder, DescribeTagsRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeTagsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>key</code> - The tag key.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-id</code> - The resource ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dhcp-options</code> |
     * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
     * <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> |
     * <code>volume</code> | <code>vpc</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>value</code> - The tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>key</code> - The tag key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-id</code> - The resource ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dhcp-options</code>
     *         | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     *         <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
     *         <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
     *         <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpn-connection</code> |
     *         <code>vpn-gateway</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>value</code> - The tag value.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the
     * remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 1000. To
     *         retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTagsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key</code> - The tag key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The resource ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dhcp-options</code> |
         * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
         * <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
         * <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
         * <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpn-connection</code> |
         * <code>vpn-gateway</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key</code> - The tag key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The resource ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - The resource type (<code>customer-gateway</code> |
         *        <code>dhcp-options</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code>
         *        | <code>network-acl</code> | <code>network-interface</code> | <code>reserved-instances</code> |
         *        <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> |
         *        <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> |
         *        <code>vpn-connection</code> | <code>vpn-gateway</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key</code> - The tag key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The resource ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dhcp-options</code> |
         * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
         * <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
         * <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
         * <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpn-connection</code> |
         * <code>vpn-gateway</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key</code> - The tag key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The resource ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - The resource type (<code>customer-gateway</code> |
         *        <code>dhcp-options</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code>
         *        | <code>network-acl</code> | <code>network-interface</code> | <code>reserved-instances</code> |
         *        <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> |
         *        <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> |
         *        <code>vpn-connection</code> | <code>vpn-gateway</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve
         * the remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 1000. To
         *        retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }
}
