/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpcAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVpcAttributeRequest.Builder, DescribeVpcAttributeRequest> {
    private final String attribute;

    private final String vpcId;

    private DescribeVpcAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The VPC attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link VpcAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeString}.
     * </p>
     * 
     * @return The VPC attribute.
     * @see VpcAttributeName
     */
    public VpcAttributeName attribute() {
        return VpcAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The VPC attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link VpcAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeString}.
     * </p>
     * 
     * @return The VPC attribute.
     * @see VpcAttributeName
     */
    public String attributeString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributeString() == null) ? 0 : attributeString().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcAttributeRequest)) {
            return false;
        }
        DescribeVpcAttributeRequest other = (DescribeVpcAttributeRequest) obj;
        if (other.attributeString() == null ^ this.attributeString() == null) {
            return false;
        }
        if (other.attributeString() != null && !other.attributeString().equals(this.attributeString())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attributeString() != null) {
            sb.append("Attribute: ").append(attributeString()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcAttributeRequest> {
        /**
         * <p>
         * The VPC attribute.
         * </p>
         * 
         * @param attribute
         *        The VPC attribute.
         * @see VpcAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The VPC attribute.
         * </p>
         * 
         * @param attribute
         *        The VPC attribute.
         * @see VpcAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcAttributeName
         */
        Builder attribute(VpcAttributeName attribute);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcAttributeRequest model) {
            attribute(model.attribute);
            vpcId(model.vpcId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(VpcAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public DescribeVpcAttributeRequest build() {
            return new DescribeVpcAttributeRequest(this);
        }
    }
}
