/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcEndpointServices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcEndpointServicesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpcEndpointServicesResponse.Builder, DescribeVpcEndpointServicesResponse> {
    private final String nextToken;

    private final List<String> serviceNames;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.serviceNames = builder.serviceNames;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of supported AWS services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of supported AWS services.
     */
    public List<String> serviceNames() {
        return serviceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((serviceNames() == null) ? 0 : serviceNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.serviceNames() == null ^ this.serviceNames() == null) {
            return false;
        }
        if (other.serviceNames() != null && !other.serviceNames().equals(this.serviceNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (serviceNames() != null) {
            sb.append("ServiceNames: ").append(serviceNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ServiceNames":
            return Optional.of(clazz.cast(serviceNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of supported AWS services.
         * </p>
         * 
         * @param serviceNames
         *        A list of supported AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(Collection<String> serviceNames);

        /**
         * <p>
         * A list of supported AWS services.
         * </p>
         * 
         * @param serviceNames
         *        A list of supported AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(String... serviceNames);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<String> serviceNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            nextToken(model.nextToken);
            serviceNames(model.serviceNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getServiceNames() {
            return serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String... serviceNames) {
            serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        @Override
        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }
    }
}
