/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DetachNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachNetworkInterfaceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachNetworkInterfaceRequest.Builder, DetachNetworkInterfaceRequest> {
    private final String attachmentId;

    private final Boolean force;

    private DetachNetworkInterfaceRequest(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Specifies whether to force a detachment.
     * </p>
     * 
     * @return Specifies whether to force a detachment.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachmentId() == null) ? 0 : attachmentId().hashCode());
        hashCode = 31 * hashCode + ((force() == null) ? 0 : force().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachNetworkInterfaceRequest)) {
            return false;
        }
        DetachNetworkInterfaceRequest other = (DetachNetworkInterfaceRequest) obj;
        if (other.attachmentId() == null ^ this.attachmentId() == null) {
            return false;
        }
        if (other.attachmentId() != null && !other.attachmentId().equals(this.attachmentId())) {
            return false;
        }
        if (other.force() == null ^ this.force() == null) {
            return false;
        }
        if (other.force() != null && !other.force().equals(this.force())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (force() != null) {
            sb.append("Force: ").append(force()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        case "Force":
            return Optional.of(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetachNetworkInterfaceRequest> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Specifies whether to force a detachment.
         * </p>
         * 
         * @param force
         *        Specifies whether to force a detachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachNetworkInterfaceRequest model) {
            attachmentId(model.attachmentId);
            force(model.force);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public DetachNetworkInterfaceRequest build() {
            return new DetachNetworkInterfaceRequest(this);
        }
    }
}
