/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DetachVolume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachVolumeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachVolumeRequest.Builder, DetachVolumeRequest> {
    private final String device;

    private final Boolean force;

    private final String instanceId;

    private final String volumeId;

    private DetachVolumeRequest(BuilderImpl builder) {
        this.device = builder.device;
        this.force = builder.force;
        this.instanceId = builder.instanceId;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file
     * system. Use this option only as a last resort to detach a volume from a failed instance. The instance won't have
     * an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file
     * system check and repair procedures.
     * </p>
     * 
     * @return Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     *         instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
     *         corrupted file system. Use this option only as a last resort to detach a volume from a failed instance.
     *         The instance won't have an opportunity to flush file system caches or file system metadata. If you use
     *         this option, you must perform file system check and repair procedures.
     */
    public Boolean force() {
        return force;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((force() == null) ? 0 : force().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest) obj;
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.force() == null ^ this.force() == null) {
            return false;
        }
        if (other.force() != null && !other.force().equals(this.force())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (force() != null) {
            sb.append("Force: ").append(force()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.of(clazz.cast(device()));
        case "Force":
            return Optional.of(clazz.cast(force()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetachVolumeRequest> {
        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
         * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted
         * file system. Use this option only as a last resort to detach a volume from a failed instance. The instance
         * won't have an opportunity to flush file system caches or file system metadata. If you use this option, you
         * must perform file system check and repair procedures.
         * </p>
         * 
         * @param force
         *        Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into
         *        an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
         *        corrupted file system. Use this option only as a last resort to detach a volume from a failed
         *        instance. The instance won't have an opportunity to flush file system caches or file system metadata.
         *        If you use this option, you must perform file system check and repair procedures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    static final class BuilderImpl implements Builder {
        private String device;

        private Boolean force;

        private String instanceId;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            device(model.device);
            force(model.force);
            instanceId(model.instanceId);
            volumeId(model.volumeId);
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }
    }
}
