/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportToS3TaskSpecification implements
        ToCopyableBuilder<ExportToS3TaskSpecification.Builder, ExportToS3TaskSpecification> {
    private final String containerFormat;

    private final String diskImageFormat;

    private final String s3Bucket;

    private final String s3Prefix;

    private ExportToS3TaskSpecification(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(containerFormat);
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public String containerFormatString() {
        return containerFormat;
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public String diskImageFormatString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     * </p>
     * 
     * @return The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     *         permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The image is written to a single object in the S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
     * diskImageFormat.
     * </p>
     * 
     * @return The image is written to a single object in the S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
     *         diskImageFormat.
     */
    public String s3Prefix() {
        return s3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((containerFormatString() == null) ? 0 : containerFormatString().hashCode());
        hashCode = 31 * hashCode + ((diskImageFormatString() == null) ? 0 : diskImageFormatString().hashCode());
        hashCode = 31 * hashCode + ((s3Bucket() == null) ? 0 : s3Bucket().hashCode());
        hashCode = 31 * hashCode + ((s3Prefix() == null) ? 0 : s3Prefix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3TaskSpecification)) {
            return false;
        }
        ExportToS3TaskSpecification other = (ExportToS3TaskSpecification) obj;
        if (other.containerFormatString() == null ^ this.containerFormatString() == null) {
            return false;
        }
        if (other.containerFormatString() != null && !other.containerFormatString().equals(this.containerFormatString())) {
            return false;
        }
        if (other.diskImageFormatString() == null ^ this.diskImageFormatString() == null) {
            return false;
        }
        if (other.diskImageFormatString() != null && !other.diskImageFormatString().equals(this.diskImageFormatString())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Prefix() == null ^ this.s3Prefix() == null) {
            return false;
        }
        if (other.s3Prefix() != null && !other.s3Prefix().equals(this.s3Prefix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (containerFormatString() != null) {
            sb.append("ContainerFormat: ").append(containerFormatString()).append(",");
        }
        if (diskImageFormatString() != null) {
            sb.append("DiskImageFormat: ").append(diskImageFormatString()).append(",");
        }
        if (s3Bucket() != null) {
            sb.append("S3Bucket: ").append(s3Bucket()).append(",");
        }
        if (s3Prefix() != null) {
            sb.append("S3Prefix: ").append(s3Prefix()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerFormat":
            return Optional.of(clazz.cast(containerFormatString()));
        case "DiskImageFormat":
            return Optional.of(clazz.cast(diskImageFormatString()));
        case "S3Bucket":
            return Optional.of(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.of(clazz.cast(s3Prefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExportToS3TaskSpecification> {
        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(String containerFormat);

        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(ContainerFormat containerFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
         * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
         *        READ_ACP permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The image is written to a single object in the S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
         * diskImageFormat.
         * </p>
         * 
         * @param s3Prefix
         *        The image is written to a single object in the S3 bucket at the S3 key s3prefix + exportTaskId + '.' +
         *        diskImageFormat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String containerFormat;

        private String diskImageFormat;

        private String s3Bucket;

        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3TaskSpecification model) {
            containerFormat(model.containerFormat);
            diskImageFormat(model.diskImageFormat);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
        }

        public final String getContainerFormat() {
            return containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public ExportToS3TaskSpecification build() {
            return new ExportToS3TaskSpecification(this);
        }
    }
}
