/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostReservationPurchasePreviewRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetHostReservationPurchasePreviewRequest.Builder, GetHostReservationPurchasePreviewRequest> {
    private final List<String> hostIdSet;

    private final String offeringId;

    private GetHostReservationPurchasePreviewRequest(BuilderImpl builder) {
        this.hostIdSet = builder.hostIdSet;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The ID/s of the Dedicated Host/s that the reservation will be associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID/s of the Dedicated Host/s that the reservation will be associated with.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The offering ID of the reservation.
     * </p>
     * 
     * @return The offering ID of the reservation.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostIdSet() == null) ? 0 : hostIdSet().hashCode());
        hashCode = 31 * hashCode + ((offeringId() == null) ? 0 : offeringId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewRequest)) {
            return false;
        }
        GetHostReservationPurchasePreviewRequest other = (GetHostReservationPurchasePreviewRequest) obj;
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostIdSet() != null) {
            sb.append("HostIdSet: ").append(hostIdSet()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostIdSet":
            return Optional.of(clazz.cast(hostIdSet()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The offering ID of the reservation.
         * </p>
         * 
         * @param offeringId
         *        The offering ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> hostIdSet;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewRequest model) {
            hostIdSet(model.hostIdSet);
            offeringId(model.offeringId);
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public GetHostReservationPurchasePreviewRequest build() {
            return new GetHostReservationPurchasePreviewRequest(this);
        }
    }
}
