/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes properties of a Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostProperties implements ToCopyableBuilder<HostProperties.Builder, HostProperties> {
    private final Integer cores;

    private final String instanceType;

    private final Integer sockets;

    private final Integer totalVCpus;

    private HostProperties(BuilderImpl builder) {
        this.cores = builder.cores;
        this.instanceType = builder.instanceType;
        this.sockets = builder.sockets;
        this.totalVCpus = builder.totalVCpus;
    }

    /**
     * <p>
     * The number of cores on the Dedicated Host.
     * </p>
     * 
     * @return The number of cores on the Dedicated Host.
     */
    public Integer cores() {
        return cores;
    }

    /**
     * <p>
     * The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
     * </p>
     * 
     * @return The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of sockets on the Dedicated Host.
     * </p>
     * 
     * @return The number of sockets on the Dedicated Host.
     */
    public Integer sockets() {
        return sockets;
    }

    /**
     * <p>
     * The number of vCPUs on the Dedicated Host.
     * </p>
     * 
     * @return The number of vCPUs on the Dedicated Host.
     */
    public Integer totalVCpus() {
        return totalVCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cores() == null) ? 0 : cores().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((sockets() == null) ? 0 : sockets().hashCode());
        hashCode = 31 * hashCode + ((totalVCpus() == null) ? 0 : totalVCpus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostProperties)) {
            return false;
        }
        HostProperties other = (HostProperties) obj;
        if (other.cores() == null ^ this.cores() == null) {
            return false;
        }
        if (other.cores() != null && !other.cores().equals(this.cores())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.sockets() == null ^ this.sockets() == null) {
            return false;
        }
        if (other.sockets() != null && !other.sockets().equals(this.sockets())) {
            return false;
        }
        if (other.totalVCpus() == null ^ this.totalVCpus() == null) {
            return false;
        }
        if (other.totalVCpus() != null && !other.totalVCpus().equals(this.totalVCpus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cores() != null) {
            sb.append("Cores: ").append(cores()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (sockets() != null) {
            sb.append("Sockets: ").append(sockets()).append(",");
        }
        if (totalVCpus() != null) {
            sb.append("TotalVCpus: ").append(totalVCpus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cores":
            return Optional.of(clazz.cast(cores()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "Sockets":
            return Optional.of(clazz.cast(sockets()));
        case "TotalVCpus":
            return Optional.of(clazz.cast(totalVCpus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostProperties> {
        /**
         * <p>
         * The number of cores on the Dedicated Host.
         * </p>
         * 
         * @param cores
         *        The number of cores on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Integer cores);

        /**
         * <p>
         * The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
         * </p>
         * 
         * @param instanceType
         *        The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of sockets on the Dedicated Host.
         * </p>
         * 
         * @param sockets
         *        The number of sockets on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sockets(Integer sockets);

        /**
         * <p>
         * The number of vCPUs on the Dedicated Host.
         * </p>
         * 
         * @param totalVCpus
         *        The number of vCPUs on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalVCpus(Integer totalVCpus);
    }

    static final class BuilderImpl implements Builder {
        private Integer cores;

        private String instanceType;

        private Integer sockets;

        private Integer totalVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(HostProperties model) {
            cores(model.cores);
            instanceType(model.instanceType);
            sockets(model.sockets);
            totalVCpus(model.totalVCpus);
        }

        public final Integer getCores() {
            return cores;
        }

        @Override
        public final Builder cores(Integer cores) {
            this.cores = cores;
            return this;
        }

        public final void setCores(Integer cores) {
            this.cores = cores;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getSockets() {
            return sockets;
        }

        @Override
        public final Builder sockets(Integer sockets) {
            this.sockets = sockets;
            return this;
        }

        public final void setSockets(Integer sockets) {
            this.sockets = sockets;
        }

        public final Integer getTotalVCpus() {
            return totalVCpus;
        }

        @Override
        public final Builder totalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
            return this;
        }

        public final void setTotalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
        }

        @Override
        public HostProperties build() {
            return new HostProperties(this);
        }
    }
}
