/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import image task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportImageTask implements ToCopyableBuilder<ImportImageTask.Builder, ImportImageTask> {
    private final String architecture;

    private final String description;

    private final String hypervisor;

    private final String imageId;

    private final String importTaskId;

    private final String licenseType;

    private final String platform;

    private final String progress;

    private final List<SnapshotDetail> snapshotDetails;

    private final String status;

    private final String statusMessage;

    private ImportImageTask(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>i386</code> | <code>x86_64</code>
     * </p>
     * 
     * @return The architecture of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>i386</code> | <code>x86_64</code>
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * A description of the import task.
     * </p>
     * 
     * @return A description of the import task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The target hypervisor for the import task.
     * </p>
     * <p>
     * Valid values: <code>xen</code>
     * </p>
     * 
     * @return The target hypervisor for the import task.</p>
     *         <p>
     *         Valid values: <code>xen</code>
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the import image task.
     * </p>
     * 
     * @return The ID of the import image task.
     */
    public String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The license type of the virtual machine.
     * </p>
     * 
     * @return The license type of the virtual machine.
     */
    public String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The description string for the import image task.
     * </p>
     * 
     * @return The description string for the import image task.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The percentage of progress of the import image task.
     * </p>
     * 
     * @return The percentage of progress of the import image task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * Information about the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the snapshots.
     */
    public List<SnapshotDetail> snapshotDetails() {
        return snapshotDetails;
    }

    /**
     * <p>
     * A brief status for the import image task.
     * </p>
     * 
     * @return A brief status for the import image task.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A descriptive status message for the import image task.
     * </p>
     * 
     * @return A descriptive status message for the import image task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((hypervisor() == null) ? 0 : hypervisor().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((importTaskId() == null) ? 0 : importTaskId().hashCode());
        hashCode = 31 * hashCode + ((licenseType() == null) ? 0 : licenseType().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((snapshotDetails() == null) ? 0 : snapshotDetails().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageTask)) {
            return false;
        }
        ImportImageTask other = (ImportImageTask) obj;
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.importTaskId() == null ^ this.importTaskId() == null) {
            return false;
        }
        if (other.importTaskId() != null && !other.importTaskId().equals(this.importTaskId())) {
            return false;
        }
        if (other.licenseType() == null ^ this.licenseType() == null) {
            return false;
        }
        if (other.licenseType() != null && !other.licenseType().equals(this.licenseType())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.snapshotDetails() == null ^ this.snapshotDetails() == null) {
            return false;
        }
        if (other.snapshotDetails() != null && !other.snapshotDetails().equals(this.snapshotDetails())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (hypervisor() != null) {
            sb.append("Hypervisor: ").append(hypervisor()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (importTaskId() != null) {
            sb.append("ImportTaskId: ").append(importTaskId()).append(",");
        }
        if (licenseType() != null) {
            sb.append("LicenseType: ").append(licenseType()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (snapshotDetails() != null) {
            sb.append("SnapshotDetails: ").append(snapshotDetails()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.of(clazz.cast(architecture()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Hypervisor":
            return Optional.of(clazz.cast(hypervisor()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "ImportTaskId":
            return Optional.of(clazz.cast(importTaskId()));
        case "LicenseType":
            return Optional.of(clazz.cast(licenseType()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "SnapshotDetails":
            return Optional.of(clazz.cast(snapshotDetails()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportImageTask> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>i386</code> | <code>x86_64</code>
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>i386</code> | <code>x86_64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * A description of the import task.
         * </p>
         * 
         * @param description
         *        A description of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The target hypervisor for the import task.
         * </p>
         * <p>
         * Valid values: <code>xen</code>
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor for the import task.</p>
         *        <p>
         *        Valid values: <code>xen</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the import image task.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The license type of the virtual machine.
         * </p>
         * 
         * @param licenseType
         *        The license type of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The description string for the import image task.
         * </p>
         * 
         * @param platform
         *        The description string for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The percentage of progress of the import image task.
         * </p>
         * 
         * @param progress
         *        The percentage of progress of the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(SnapshotDetail... snapshotDetails);

        /**
         * <p>
         * A brief status for the import image task.
         * </p>
         * 
         * @param status
         *        A brief status for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A descriptive status message for the import image task.
         * </p>
         * 
         * @param statusMessage
         *        A descriptive status message for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String architecture;

        private String description;

        private String hypervisor;

        private String imageId;

        private String importTaskId;

        private String licenseType;

        private String platform;

        private String progress;

        private List<SnapshotDetail> snapshotDetails;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageTask model) {
            architecture(model.architecture);
            description(model.description);
            hypervisor(model.hypervisor);
            imageId(model.imageId);
            importTaskId(model.importTaskId);
            licenseType(model.licenseType);
            platform(model.platform);
            progress(model.progress);
            snapshotDetails(model.snapshotDetails);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<SnapshotDetail.Builder> getSnapshotDetails() {
            return snapshotDetails != null ? snapshotDetails.stream().map(SnapshotDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail... snapshotDetails) {
            snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail.BuilderImpl> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copyFromBuilder(snapshotDetails);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ImportImageTask build() {
            return new ImportImageTask(this);
        }
    }
}
