/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes association information for an Elastic IP address (IPv4).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworkInterfaceAssociation implements
        ToCopyableBuilder<InstanceNetworkInterfaceAssociation.Builder, InstanceNetworkInterfaceAssociation> {
    private final String ipOwnerId;

    private final String publicDnsName;

    private final String publicIp;

    private InstanceNetworkInterfaceAssociation(BuilderImpl builder) {
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The ID of the owner of the Elastic IP address.
     * </p>
     * 
     * @return The ID of the owner of the Elastic IP address.
     */
    public String ipOwnerId() {
        return ipOwnerId;
    }

    /**
     * <p>
     * The public DNS name.
     * </p>
     * 
     * @return The public DNS name.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IP address or Elastic IP address bound to the network interface.
     * </p>
     * 
     * @return The public IP address or Elastic IP address bound to the network interface.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ipOwnerId() == null) ? 0 : ipOwnerId().hashCode());
        hashCode = 31 * hashCode + ((publicDnsName() == null) ? 0 : publicDnsName().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAssociation)) {
            return false;
        }
        InstanceNetworkInterfaceAssociation other = (InstanceNetworkInterfaceAssociation) obj;
        if (other.ipOwnerId() == null ^ this.ipOwnerId() == null) {
            return false;
        }
        if (other.ipOwnerId() != null && !other.ipOwnerId().equals(this.ipOwnerId())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ipOwnerId() != null) {
            sb.append("IpOwnerId: ").append(ipOwnerId()).append(",");
        }
        if (publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(publicDnsName()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpOwnerId":
            return Optional.of(clazz.cast(ipOwnerId()));
        case "PublicDnsName":
            return Optional.of(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.of(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworkInterfaceAssociation> {
        /**
         * <p>
         * The ID of the owner of the Elastic IP address.
         * </p>
         * 
         * @param ipOwnerId
         *        The ID of the owner of the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipOwnerId(String ipOwnerId);

        /**
         * <p>
         * The public DNS name.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IP address or Elastic IP address bound to the network interface.
         * </p>
         * 
         * @param publicIp
         *        The public IP address or Elastic IP address bound to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String ipOwnerId;

        private String publicDnsName;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAssociation model) {
            ipOwnerId(model.ipOwnerId);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
        }

        public final String getIpOwnerId() {
            return ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public InstanceNetworkInterfaceAssociation build() {
            return new InstanceNetworkInterfaceAssociation(this);
        }
    }
}
